

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URLDecoder;
import bsh.Interpreter;

import com.sun.xml.internal.fastinfoset.Decoder;

public class ProcessingUnit extends Thread {
	Socket client;

	public ProcessingUnit(Socket client) {
		this.client = client;
	}

	@Override
	public void run() {
		try {
			processClient(client);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			System.out.println("Connection close.");
		}
	}

	private void processClient(Socket client) throws IOException {
		InputStream in = client.getInputStream();
		OutputStream out = client.getOutputStream();
		BufferedReader bIn = new BufferedReader(new InputStreamReader(in));
		BufferedOutputStream bOut = new BufferedOutputStream(out);
		//bOut.write("HTTP/1.1 200 OK\nServer: YoshiServer\n\n".getBytes());
		
		String line = "";
		while ((line = bIn.readLine()) != null) {
			// System.out.println(line);
			String[] cmd = line.split(" ");//split a line into cmd[] 
			if (cmd[0].equalsIgnoreCase("GET")) {
				System.out.println(line); // we skip all other lines except
											// those starting with "GET"
				try {
					FileInputStream toSendFile = new FileInputStream("WWW/"
							+ cmd[1].substring(1));
					BufferedInputStream fileToSend = new BufferedInputStream(
							toSendFile);
					int data = 0;
					while ((data = fileToSend.read()) != -1) {
						bOut.write(data);
					}
					bOut.flush();
					break;
				} catch (FileNotFoundException e) {
					bOut.write("Page no found.\n\n".getBytes());
					break;
				}
			}
			if (cmd[0].equalsIgnoreCase("POST")){
				System.out.println(line);
				PrintStream origin = new PrintStream(System.out);
				PrintStream pOut = new PrintStream((OutputStream)(new BRFilter(out)));
				int temp=0;
				int i, len=0;
				FileWriter file = new FileWriter("UPLOAD/" + System.currentTimeMillis()
					+".txt");
				BufferedWriter save = new BufferedWriter(file);
				String src = "";
				String Len = "";
				while((src=bIn.readLine())!=null){
					if(src.startsWith("Content-Length")){
						int start = src.indexOf(":");
						Len = src.substring(start+2);
						len = Integer.parseInt(Len);
					}
					if(src.equalsIgnoreCase(""))break;
				}
				
				src = "";
				for(i=0; i<len; i++){
					src = src + (char)bIn.read();
				}
				src = src.substring(5);
				String decoded = URLDecoder.decode(src, "big5");
				try{
					save.write(decoded);
					save.flush();
					save.close();
					System.out.println("File saved.\n");
				}catch(IOException e){
					e.getMessage();
					System.out.println("File saving failed.\n");
				}
				Interpreter bsh = new Interpreter();
				
				System.setOut(pOut);
				System.setErr(pOut);
				
				try{
					bsh.eval(decoded);
					
				}catch(Exception e){
					e.printStackTrace();
				}
				System.out.flush();
				System.err.flush();
				System.setOut(origin);
				System.setErr(origin);
				pOut.close();
				origin.close();
				break;
			}
		
			
		}
		in.close();
		out.close();
		bIn.close();
		bOut.close();
		
		client.close();
	}

}
